local t = Def.ActorFrame {};

-- Sort
t[#t+1] = LoadActor("_disc") .. {
	InitCommand=cmd(x,SCREEN_RIGHT-350;y,SCREEN_TOP+60);
	OnCommand=cmd(diffusealpha,0;bouncebegin,0.3;diffusealpha,1;;);
	OffCommand=cmd(bouncebegin,0.3;diffusealpha,0;);
};

t[#t+1] = LoadFont("_sf collegiate italic 46px") .. {
		InitCommand=cmd(x,SCREEN_RIGHT-324;y,SCREEN_TOP+60;zoom,0.75;strokecolor,color("#FFFFFF");diffuse,color("#000000");horizalign,left;shadowlength,1;);
		OnCommand=cmd(diffusealpha,0;rotationz,10;bouncebegin,0.3;diffusealpha,1;rotationz,0;);
		OffCommand=cmd(bouncebegin,0.3;diffusealpha,0;);
        SortOrderChangedMessageCommand=cmd(playcommand,"Set");
        ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
        SetCommand=function(self)
               local sortorder = GAMESTATE:GetSortOrder();
               if sortorder then
					self:finishtweening();
					self:diffusealpha(0);
                    self:settext(SortOrderToLocalizedString(sortorder));
                    self:playcommand("Refresh");
					self:decelerate(0.2):diffusealpha(1);
				else
					self:settext("");
					self:playcommand("Refresh");
               end
        end;
};


t[#t+1] = Def.ActorFrame {
			InitCommand=cmd(x,SCREEN_CENTER_X-100;y,SCREEN_CENTER_Y-106;zoom,0.75;rotationz,-5);
			OnCommand=function(self)
				self:rotationz(15):zoom(0.5):diffusealpha(0):bouncebegin(0.6):diffusealpha(1):zoom(0.8):rotationz(-5):bounceend(0.3):zoom(0.75);
			end;			
			OffCommand=function(self)
				self:bouncebegin(0.6):zoom(0.5):rotationz(-20):diffusealpha(0);
			end;
			LoadActor("_jacket shell") .. {
				InitCommand=cmd(zoom,0.55);
			};
				-- Preview video	
				Def.Sprite {
						name="PreviewVideo";
						InitCommand=cmd(scaletoclipped,246,246;);
						CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
						SetCommand=function(self)
							local song = GAMESTATE:GetCurrentSong();
							if song then
							if song:HasPreviewVid() then
								self:visible(false)
								self:sleep(0.01)
								self:Load(song:GetPreviewVidPath())
								self:sleep(0.05)
								self:position(0)
								self:visible(true)
							else
								self:Load(nil)
								self:visible(false)
							end
							else
								self:Load(nil)
								self:visible(false)
							end
						end;
					};
				-- Jacket sprite
				Def.Sprite {
					name="SongJacket";
					InitCommand=cmd();
					CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
					CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
					SetCommand=function(self)
						local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
							if target then
								if GAMESTATE:IsCourseMode() == false then
									if target:HasJacket() == true then
										self:Load(target:GetJacketPath())
										self:scaletoclipped(246,246)
										self:playcommand("Transition")
									elseif target:HasBackground() == true then
										self:Load(target:GetBackgroundPath())
										self:scaletoclipped(246,246)
										self:playcommand("Transition")
									elseif target:HasBanner() == true then
										self:Load(target:GetBannerPath())
										self:scaletoclipped(256,80)
										self:playcommand("Transition")
									elseif target:HasBanner() == false then
										self:Load(THEME:GetPathG("Common fallback", "jacket"))
										self:scaletoclipped(246,246)
										self:playcommand("Transition")
									end
								else
									if target:HasBanner() == true then
										self:Load(target:GetBannerPath())
										self:scaletoclipped(246,246)
									elseif target:HasBanner() == false then
										self:Load(THEME:GetPathG("Common fallback", "jacket"))
										self:scaletoclipped(246,246)
										self:playcommand("Transition")
									end
								end;
							else
								self:Load(THEME:GetPathG("Common fallback", "jacket"))
							end
					end;
					TransitionCommand=function(self)
					local song = GAMESTATE:GetCurrentSong();
							if song then
								if song:HasPreviewVid() then
									self:finishtweening():diffusealpha(1):sleep(1.2):smooth(0.6):diffusealpha(0);
								else
									self:finishtweening():diffusealpha(1)
								end;
							end;
						end;   
				};
		};
		
if GAMESTATE:IsCourseMode() == false then
t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");		
end;

--BPM goes here
if GAMESTATE:IsCourseMode() == false then
t[#t+1] = LoadActor("_bpmstripe") .. {
	InitCommand=cmd(zoom,0.75;x,SCREEN_LEFT+130;y,SCREEN_CENTER_Y-100);
	OnCommand=cmd(diffusealpha,0;sleep,1;smooth,0.2;diffusealpha,1;);
	OffCommand=cmd(linear,0.3;diffusealpha,0;);
};
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
end

t[#t+1] = LoadActor("_lengthstripe") .. {
	InitCommand=cmd(zoom,0.75;x,SCREEN_LEFT+107;y,SCREEN_CENTER_Y-40);
	OnCommand=cmd(diffusealpha,0;sleep,1.3;smooth,0.3;diffusealpha,1;);
	OffCommand=cmd(linear,0.3;diffusealpha,0;);
};

t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. {
	SetCommand=function(self)
		local curSelection = nil;
		local length = 0.0;
		if GAMESTATE:IsCourseMode() then
			curSelection = GAMESTATE:GetCurrentCourse();
			self:playcommand("Reset");
			if curSelection then
				local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
				if trail then
					length = TrailUtil.GetTotalSeconds(trail);
				else
					length = 0.0;
				end;
			else
				length = 0.0;
			end;
		else
			curSelection = GAMESTATE:GetCurrentSong();
			self:playcommand("Reset");
			if curSelection then
				length = curSelection:MusicLengthSeconds();
				if curSelection:IsLong() then
					self:playcommand("Long");
				elseif curSelection:IsMarathon() then
					self:playcommand("Marathon");
				else
					self:playcommand("Reset");
				end
			else
				length = 0.0;
				self:playcommand("Reset");
			end;
		end;
		self:settext( SecondsToMSS(length) );
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
};

t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(Center;draworder,160;zoomto,SCREEN_WIDTH,100;diffuse,color("#7E8483");diffusealpha,0);
		ShowPressStartForOptionsCommand=cmd(sleep,0.2;decelerate,0.5;diffusealpha,1);
		ShowEnteringOptionsCommand=cmd(sleep,0.2;decelerate,0.5;diffusealpha,0);
		HidePressStartForOptionsCommand=cmd(sleep,0.2;decelerate,0.5;diffusealpha,0);
	};
};


t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptionsText") .. {
	ShowPressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsShowCommand");
	ShowEnteringOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsEnterCommand");
	HidePressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsHideCommand");
};

return t;